/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import cz.insophy.inplan.planning.mokos.AbstractScorer;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.util.Tuple;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCachingOperationScorer<T extends Comparable<T>>
extends AbstractScorer<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCachingOperationScorer.class);
    boolean hasToCompute = true;

    public AbstractCachingOperationScorer(String scoreProperty) {
        super(scoreProperty);
    }

    protected abstract T getOperationScore(Operation var1);

    @Override
    public final Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        if (this.hasToCompute) {
            log.debug("{} scores!", (Object)this.getClass());
            for (Operation op : ops) {
                op.setProperty(this.getScoreProperty(), this.getOperationScore(op));
            }
            this.hasToCompute = false;
        }
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }
}

